/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.recipe;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import io.netty.handler.codec.DecoderException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.resources.recipe.neoforge.BlockTypeSwapIngredientImpl;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public abstract class BlockTypeSwapIngredient<T extends BlockType> {
    protected final Ingredient inner;
    protected final T fromType;
    protected final T toType;
    protected final BlockTypeRegistry<T> registry;
    private List<ItemStack> items;
    public static final ResourceLocation ID = Moonlight.res("block_type_swap");
    public static final MapCodec<BlockTypeSwapIngredient<?>> CODEC = BlockTypeSwapIngredient.makeCodec(false);
    public static final MapCodec<BlockTypeSwapIngredient<?>> CODEC_NONEMPTY = BlockTypeSwapIngredient.makeCodec(true);
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockTypeSwapIngredient<?>> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, BlockTypeSwapIngredient<?>>(){

        public BlockTypeSwapIngredient<?> decode(RegistryFriendlyByteBuf object) {
            Ingredient inner = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)object);
            BlockTypeRegistry reg = (BlockTypeRegistry)BlockTypeRegistry.getRegistryStreamCodec().decode((Object)object);
            StreamCodec slowCodec = reg.getStreamCodecExplicit();
            try {
                BlockType from = (BlockType)slowCodec.decode((Object)object);
                BlockType to = (BlockType)slowCodec.decode((Object)object);
                return BlockTypeSwapIngredient.create(inner, from, to, reg);
            }
            catch (DecoderException e) {
                throw new RuntimeException("Failed to decode block type swap ingredient", e);
            }
        }

        public void encode(RegistryFriendlyByteBuf buf, BlockTypeSwapIngredient<?> ing) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ing.inner);
            BlockTypeRegistry.getRegistryStreamCodec().encode((Object)buf, ing.registry);
            StreamCodec streamCodec = ing.registry.getStreamCodecExplicit();
            streamCodec.encode((Object)buf, ing.fromType);
            streamCodec.encode((Object)buf, ing.toType);
        }
    };

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends BlockType> Ingredient create(Ingredient original, @NotNull T from, @NotNull T to) {
        void var2_2;
        void var1_1;
        return BlockTypeSwapIngredientImpl.create(original, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends BlockType> BlockTypeSwapIngredient<T> create(Ingredient original, @NotNull T from, @NotNull T to, BlockTypeRegistry<T> reg) {
        void var3_3;
        void var2_2;
        void var1_1;
        return BlockTypeSwapIngredientImpl.create(original, var1_1, var2_2, var3_3);
    }

    protected BlockTypeSwapIngredient(Ingredient inner, T fromType, T toType, BlockTypeRegistry<T> reg) {
        Preconditions.checkNotNull(toType, (Object)"Found null to block type for BlockTypeSwapIngredient");
        Preconditions.checkNotNull(fromType, (Object)"Found null from block type for BlockTypeSwapIngredient");
        this.inner = inner;
        this.fromType = fromType;
        this.toType = toType;
        this.registry = reg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof BlockTypeSwapIngredient)) return false;
        BlockTypeSwapIngredient ing = (BlockTypeSwapIngredient)obj;
        if (!this.inner.equals((Object)ing.inner)) return false;
        if (this.fromType != ing.fromType) return false;
        if (this.toType != ing.toType) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.inner, this.fromType, this.toType);
    }

    public Ingredient getInner() {
        return this.inner;
    }

    public boolean test(ItemStack stack) {
        if (stack != null) {
            for (ItemStack itemStack : this.getMatchingStacks()) {
                if (!itemStack.is(stack.getItem())) continue;
                return true;
            }
        }
        return false;
    }

    public final List<ItemStack> convertItems(List<ItemStack> toConvert) {
        ItemStack it;
        T type;
        ArrayList<ItemStack> newItems = new ArrayList<ItemStack>();
        boolean success = false;
        Iterator<ItemStack> iterator = toConvert.iterator();
        while (iterator.hasNext() && (type = this.registry.getBlockTypeOf((ItemLike)(it = iterator.next()).getItem())) == this.fromType) {
            Item newItem = BlockType.changeItemType(it.getItem(), this.fromType, this.toType);
            if (newItem == null) continue;
            newItems.add(it.transmuteCopy((ItemLike)newItem));
            success = true;
        }
        if (!success) {
            newItems.addAll(toConvert);
        }
        return newItems;
    }

    public List<ItemStack> getMatchingStacks() {
        if (this.items == null) {
            this.items = this.convertItems(Arrays.asList(this.inner.getItems()));
        }
        return this.items;
    }

    @NotNull
    private static MapCodec<BlockTypeSwapIngredient<?>> makeCodec(final boolean nonEmpty) {
        return new MapCodec<BlockTypeSwapIngredient<?>>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.of("block_type", "from", "to", "ingredient").map(arg_0 -> ops.createString(arg_0));
            }

            public <T> DataResult<BlockTypeSwapIngredient<?>> decode(DynamicOps<T> ops, MapLike<T> input) {
                Codec ingCodec = nonEmpty ? Ingredient.CODEC_NONEMPTY : Ingredient.CODEC;
                Ingredient inner = (Ingredient)ingCodec.parse(ops, input.get(ops.createString("ingredient"))).result().orElseThrow();
                BlockTypeRegistry reg = (BlockTypeRegistry)BlockTypeRegistry.getRegistryCodec().parse(ops, input.get(ops.createString("block_type"))).result().orElseThrow();
                Object fromType = ops.createString("from");
                BlockType from = (BlockType)reg.getCodec().parse(ops, input.get(fromType)).result().orElseThrow();
                Object toType = ops.createString("to");
                BlockType to = (BlockType)reg.getCodec().parse(ops, input.get(toType)).result().orElseThrow();
                return DataResult.success(BlockTypeSwapIngredient.create(inner, from, to, reg));
            }

            public <T> RecordBuilder<T> encode(BlockTypeSwapIngredient<?> ingr, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                Codec ingCodec = nonEmpty ? Ingredient.CODEC_NONEMPTY : Ingredient.CODEC;
                prefix.add(ops.createString("ingredient"), ingCodec.encodeStart(ops, (Object)ingr.inner));
                prefix.add(ops.createString("block_type"), BlockTypeRegistry.getRegistryCodec().encodeStart(ops, ingr.registry));
                Codec codec = ingr.registry.getCodec();
                prefix.add(ops.createString("from"), codec.encodeStart(ops, ingr.fromType));
                prefix.add(ops.createString("to"), codec.encodeStart(ops, ingr.toType));
                return prefix;
            }
        };
    }
}

